%%%% A Matlab Code for 3D Non-Penalization SEMDOT Algorithm %%%%
% Example SEMDOT3D(40, 0.3, 2, 1, 2)
function SEMDOT3D(nelx, vol, rmin, index_obj, index_initial)
%% Basic Parameters
nely=nelx; nelz=nelx;
lx=1; ly=lx; lz=lx;
dx=lx/nelx; dy=ly/nely; dz=lz/nelz; scale_obj=1;
%% USER-DEFINED LOOP PARAMETERS
maxloop = 1000; tolx = 0.001; nele = nelx*nely*nelz;
%% USER-DEFINED MATERIAL PROPERTIES
E0 = 1; Emin = 0.001; nu = [0.3;0.3]; E=[E0;Emin];
%% USER-DEFINED GRID POINTS
nG=5; ngrid=nG-1;
%% INITIALIZE HEAVISIDE REGULARIZATION PARAMETER
beta=0.5; ER=0.5;
%% ELEMENTAL NODES AND COORDINATES
[nodex,nodey,nodez] = meshgrid(0:nelx,0:nely,0:nelz);
[fnx,fny,fnz] = meshgrid(0:1/ngrid:nelx,0:1/ngrid:nely,0:1/ngrid:nelz);
%% FILTER
[H,Hs]=HHs(nelx,nely,nelz,rmin);
[Hn,Hns]=HnHns(nelx,nely,nelz);
%% INITIALIZE ITERATION
vx=initial_x(nelx,nely,nelz,vol,index_initial);
vxPhys = vx;
[keLambda,keMu,feLambda,feMu]=KEFE(dx,dy,dz);
[nele,edofMat,ndof]=PRE_HOMOGENIZATION(nelx,nely,nelz);
loop = 0; change = 1;
%% INITIALIZE MMA OPTIMIZER
m = 1; n = nele; xmin = zeros(n,1); xmax = ones(n,1);        
xold1 = vx(:); xold2 = vx(:); low = ones(n,1); upp = ones(n,1);        
a0 = 1; a = zeros(m,1); c_MMA = 10000*ones(m,1); d = zeros(m,1);       
%% START ITERATION
while (change > tolx || tol>0.001) && loop < maxloop
    %% UPDATE ITERATION
    loop = loop+1;
    [CH,dCH]=Homogenization_3D(nelx,nely,nelz,lx,ly,lz,vxPhys,E,nu,keLambda,keMu,feLambda,feMu,nele,edofMat,ndof);
    [Output,dOutput]=obj_dobj(CH,dCH,index_obj);
    dc=dOutput;
    dv = ones(nely,nelx,nelz);
    %% FILTERING AND MODIFICATION OF SENSITIVITIES
    dc(:) = H*(dc(:)./Hs);
    dv(:) = H*(dv(:)./Hs);
    %% METHOD OF MOVING ASYMPTOTES
    xval  = vx(:);
    f0val = scale_obj*Output;
    df0dx = scale_obj*dc(:);
    fval  = sum(vxPhys(:))/(vol*nele) - 1;
    dfdx  = dv(:)' / (vol*nele);
    [vxmma, ~, ~, ~, ~, ~, ~, ~, ~, low,upp] = ...
        mmasub(m, n, loop, xval, xmin, xmax, xold1, xold2, ...
        f0val,df0dx,fval,dfdx,low,upp,a0,a,c_MMA,d);
    %% Update MMA Variables
    vxnew     = reshape(vxmma,nely,nelx,nelz);
    vxPhys(:) = (H*vxnew(:))./Hs;
    xold2    = xold1(:);
    xold1    = vx(:);
    xn = reshape((Hn*vxPhys(:)./Hns),nely+1,nelx+1,nelz+1);
    %% UPDATE POINT DESNIGY BY A HEAVISIDE SMOOTH FUNCTION/ HEAVISIDE STEP FUNCTION
    xg = interp3(nodex,nodey,nodez,xn,fnx,fny,fnz,'linear');
    l1 =0; l2 = 1;
    while (l2-l1) > 1.0e-5
        ls = (l1+l2)/2.0;
        %% Heaviside smooth function
        xgnew = max(0.001,(tanh(beta*ls)+tanh(beta*(xg-ls)))/(tanh(beta*ls)+tanh(beta*(1-ls))));
        if sum(sum(sum(xgnew)))/((ngrid*nelx+1)*(ngrid*nely+1)*(ngrid*nelz+1)) - sum(vxPhys(:))/(nele) > 0
            l1 = ls;
        else
            l2 = ls;
        end
    end
    %% CONVERTING TO ELEMENTS
    vxPhys(:) = 0;
    Terr = 0;
    Tm=[];
    for nk = 1:nelz
        for ni = 1:nelx
            for nj = 1:nely
                ne = (nk-1)*nelx*nely+(ni-1)*nely+nj;
                for nk1 = ngrid*(nk-1)+1:ngrid*nk+1
                    for ni1 = ngrid*(ni-1)+1:ngrid*ni+1
                        for nj1 = ngrid*(nj-1)+1:ngrid*nj+1
                            Tm=[Tm;xgnew(nj1,ni1,nk1)];
                            vxPhys(ne) = vxPhys(ne)+xgnew(nj1,ni1,nk1);
                        end
                    end
                end
                if min(Tm)>0.001 && max(Tm)<1
                    Terr=Terr+1;
                end
                Tm=[];
            end
        end
    end
    vxPhys = vxPhys/((ngrid+1)^3);
    %% Topology Error
    tol = Terr/nele;
    %% CHECK CONVERGENCE
    change = sum(abs(vxnew(:)-vx(:)))/(vol*nele);
    vx=vxnew;
    %% PRINT RESULTS
    fprintf('It.:%5i Obj.:%11.5f Vol.:%7.3f ch.:%7.5f Topo.:%7.5f\n',loop,Output,mean(vxPhys(:)),change,tol);
    figure(1)
    clf;
    top = xg-ls;
    display_3Dsmooth(xg,top,loop);
    %% UPDATE% HEAVISIDE REGULARIZATION PARAMETER
    beta=beta+ER;
    fprintf('Parameter beta increased to %g.\n',beta);
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This code was written by:                                               %
%                                                                         %
% Dr. Yun-Fei Fu                                                          %
% Department of Mechanical Engineering, University of Alberta, Canada     %
%                                                                         %
% Prof. Bernard Rolfe                                                     %
% School of Engineering, Faculty of Science Engineering and               %
% Built Environment, Deakin University, Australia                         %
%                                                                         %
% Please send your comments and questions to: jackyunfei.fu@outlook.com   %
%                                                                         %
% The code is intended for educational purposes and theoretical details   %
% are discussed in the book: "Smooth Topological Design of Continuum      %
% Structures", YF Fu and B Rolfe, CRC press.                              %
%                                                                         %
%                                                                         %
% E Andreassen and CS Andreasen. How to determine composite material      %  
% properties using numerical homogenization. Computational Materials      %
% Science 83 (2014): 488-495. doi: 10.1016/j.commatsci.2013.09.006        %
%                                                                         %
% Disclaimer:                                                             %
% The authors do not guarantee that the code is free from errors.         %
% Furthermore, the authors shall not be liable in any event caused by the %
% use of the program.                                                     %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
